package gov.va.med.mhv.health.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PHR_ALLERGY")
public class VAAllergy implements Serializable {
	private static final long serialVersionUID = -1635321973383632356L;
	
    @Id
	@Column(name="PHR_ALLERGY_ID")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="PATIENT_ID")
	private Long patientId;
	
	@Column(name="FACILITY_NAME")
	private String facilityName;
	
	@Column(name="PHR_FACILITY_CONTROL_ID")
	private Long phrFacilityControlId;
	
	@Column(name="FACILITY_INFO_ID")
	private Long facilityInfoId;
	
	@Column(name="STATION_NUMBER")
	private String stationNumber;
	
	@Lob
	@Column(name="COMMENTS")
	private String comments;
	
	@Column(name="OBSERVED")
	private String observed;
	
	@Lob
	@Column(name="REACTION")
	private String reaction;
	
	@Column(name="ALLERGY_TYPE")
	private String allergyType;
	
	@Lob
	@Column(name="DRUG_CLASS")
	private String drugClass;
	
	@Column(name="REACTANT")
	private String reactant;
	
	@Column(name="RECORD_ID")
	private String recordId;
	
	@Column(name="OBSERVATION_DATE_PRECISE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date observationDate;
	
	@Column(name="OBSERVATION_DATE_IMPRECISE")
	private String observationDateImprecise;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPatientId() {
		return patientId;
	}

	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}

	public String getFacilityName() {
		return facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}

	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}

	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}

	public Long getFacilityInfoId() {
		return facilityInfoId;
	}

	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}

	public String getStationNumber() {
		return stationNumber;
	}

	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getObserved() {
		return observed;
	}

	public void setObserved(String observed) {
		this.observed = observed;
	}

	public String getReaction() {
		return reaction;
	}

	public void setReaction(String reaction) {
		this.reaction = reaction;
	}

	public String getAllergyType() {
		return allergyType;
	}

	public void setAllergyType(String allergyType) {
		this.allergyType = allergyType;
	}

	public String getDrugClass() {
		return drugClass;
	}

	public void setDrugClass(String drugClass) {
		this.drugClass = drugClass;
	}

	public String getReactant() {
		return reactant;
	}

	public void setReactant(String reactant) {
		this.reactant = reactant;
	}

	public String getRecordId() {
		return recordId;
	}

	public void setRecordId(String recordId) {
		this.recordId = recordId;
	}

	public Date getObservationDate() {
		return observationDate;
	}

	public void setObservationDate(Date observationDate) {
		this.observationDate = observationDate;
	}

	public String getObservationDateImprecise() {
		return observationDateImprecise;
	}

	public void setObservationDateImprecise(String observationDateImprecise) {
		this.observationDateImprecise = observationDateImprecise;
	}
}
